<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RecommendationAttachments extends Model 
{

    protected $table = 'recommendation_attachments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('attachment_type_id', 'path', 'recommendation_id');

    public function recommendation()
    {
        return $this->belongsTo('App\Models\Recommendation');
    }

}